import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/utils/dimensions.dart';
import 'package:viser_remit/core/utils/my_color.dart';
import 'package:viser_remit/view/components/bottom-sheet/bottom_sheet_close_button.dart';
import 'package:viser_remit/view/components/text/bottom_sheet_header_text.dart';

class BottomSheetHeaderRow extends StatelessWidget {
  final String header ;
  final double bottomSpace;
  final bool isShowCloseButton;
  const BottomSheetHeaderRow({Key? key,this.header = '',this.bottomSpace = Dimensions.space10, this.isShowCloseButton = true}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return  Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Align(
          alignment: Alignment.topCenter,
          child: Container(
            height: 5,
            width: 50,
            decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(8),
              color: MyColor.colorGrey.withOpacity(0.2),
            ),
          ),
        ),
        const SizedBox(height: 2,),
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children:[
            Expanded(child: BottomSheetHeaderText(text: header.tr)),
            isShowCloseButton ?  const BottomSheetCloseButton() : const SizedBox.shrink()
          ],
        ),
        SizedBox(height: bottomSpace),
      ],
    );
  }
}
